package com.ejie.ab18a.service;

import com.ejie.ab18a.dao.Ab18aTipoBoletinDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aTipoBoletin;

/**
 * Ab18a06s00ServiceImpl generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

@Service(value = "ab18a06s00Service")
public class Ab18aTipoBoletinServiceImpl implements Ab18aTipoBoletinService {

	@Autowired
	private Ab18aTipoBoletinDao ab18a06s00Dao;

	/**
	 * Inserts a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Ab18a06s00
	 * @throws Exception
	 * @throws DataAccessException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTipoBoletin add(Ab18aTipoBoletin ab18a06s00) throws DataAccessException, Exception {
		return this.ab18a06s00Dao.add(ab18a06s00);
	}

	/**
	 * Updates a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Ab18a06s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTipoBoletin update(Ab18aTipoBoletin ab18a06s00) {
		return this.ab18a06s00Dao.update(ab18a06s00);
	}

	/**
	 * Finds a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Ab18a06s00
	 */
	public Ab18aTipoBoletin find(Ab18aTipoBoletin ab18a06s00) {
		return (Ab18aTipoBoletin) this.ab18a06s00Dao.find(ab18a06s00);
	}

	/**
	 * Finds a single row in the Ab18a06s00 table by desc.
	 * 
	 * @param tipoBoletin
	 *            Ab18aTipoBoletin
	 * @return Ab18aTipoBoletin
	 */
	public Ab18aTipoBoletin findByDesc(Ab18aTipoBoletin tipoBoletin) {
		return (Ab18aTipoBoletin) this.ab18a06s00Dao.findByDesc(tipoBoletin);
	}

	/**
	 * Deletes a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ab18aTipoBoletin ab18a06s00) {
		this.ab18a06s00Dao.remove(ab18a06s00);
	}

	/**
	 * Finds a list of rows in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a06s00>
	 */
	public List<Ab18aTipoBoletin> findAll(Ab18aTipoBoletin ab18a06s00, JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aTipoBoletin>) this.ab18a06s00Dao.findAll(ab18a06s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab18a06s00 table using like.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a06s00>
	 */
	public List<Ab18aTipoBoletin> findAllLike(Ab18aTipoBoletin ab18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Ab18aTipoBoletin>) this.ab18a06s00Dao.findAllLike(ab18a06s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab18a06s00Dao.removeMultiple(filterAb18a06s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18a06s00>
	 */
	public JQGridResponseDto<Ab18aTipoBoletin> filter(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Ab18aTipoBoletin> listaAb18a06s00 = this.ab18a06s00Dao.findAllLike(filterAb18a06s00, jqGridRequestDto, false);
		Long recordNum = this.ab18a06s00Dao.findAllLikeCount(filterAb18a06s00 != null ? filterAb18a06s00 : new Ab18aTipoBoletin(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Ab18aTipoBoletin>> reorderSelection = this.ab18a06s00Dao
					.reorderSelection(filterAb18a06s00, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<Ab18aTipoBoletin>(jqGridRequestDto, recordNum, listaAb18a06s00, reorderSelection);
		}
		return new JQGridResponseDto<Ab18aTipoBoletin>(jqGridRequestDto, recordNum, listaAb18a06s00);
	}

	/**
	 * Searches rows in the Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param searchAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a06s00>>
	 */
	public List<TableRowDto<Ab18aTipoBoletin>> search(Ab18aTipoBoletin filterAb18a06s00, Ab18aTipoBoletin searchAb18a06s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab18a06s00Dao.search(filterAb18a06s00, searchAb18a06s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab18a06s00Dao.reorderSelection(filterAb18a06s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a06s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTipoBoletin>> jerarquia(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Ab18aTipoBoletin>> listaAb18a06s00 = this.ab18a06s00Dao.findAllLikeJerarquia(filterAb18a06s00, jqGridRequestDto);
		Long recordNum = this.ab18a06s00Dao.findAllLikeCountJerarquia(filterAb18a06s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Ab18aTipoBoletin>>(jqGridRequestDto, recordNum, listaAb18a06s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a06s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTipoBoletin>> jerarquiaChildren(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Ab18aTipoBoletin>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Ab18aTipoBoletin>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN, this.ab18a06s00Dao.findAllChild(filterAb18a06s00, jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * @param ab18a06s00Dao
	 *            the ab18a06s00Dao to set
	 */
	public void setAb18a06s00Dao(Ab18aTipoBoletinDao ab18a06s00Dao) {
		this.ab18a06s00Dao = ab18a06s00Dao;
	}

	@Override
	public Long findAllLikeCount(Ab18aTipoBoletin boletinFiltro, boolean b) {
		return this.ab18a06s00Dao.findAllLikeCount(boletinFiltro, b);
	}
}
